/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "myriexpress.h"
#include "test_common.h"

#define MAX_LEN  (1 << SIZE) /* 262144 */
#define SIZE     17 /* was 18 */

int main(void)
{
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  char send_buff[MAX_LEN];
  char recv_buff[MAX_LEN];
  mx_segment_t send_seg;
  mx_segment_t recv_seg;
  mx_segment_t null_seg;
  mx_request_t send_req[SIZE + 1];
  mx_request_t recv_req;
  mx_status_t status;
  mx_return_t ret;
  uint32_t result;
  int i, len;

  mx_set_error_handler(MX_ERRORS_RETURN);
  ret = mx_init();
  insist(ret == MX_SUCCESS);
  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);
  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);

  send_seg.segment_ptr = send_buff;
  send_seg.segment_length = 80;
  recv_seg.segment_ptr = recv_buff;
  recv_seg.segment_length = 80;
  null_seg.segment_ptr = 0;
  null_seg.segment_length = 0;

  /* check unexpected path */
  printf ("Test unexpected msg.\n");
  fflush(stdout);
  ret = mx_issend(ep, &send_seg, 1, addr, 10, NULL, &send_req[0]);
  insist(ret == MX_SUCCESS);
  ret = mx_wait(ep, &send_req[0], 1000, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 0));
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  insist(ret == MX_SUCCESS);
  ret = mx_wait(ep, &send_req[0], MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  ret = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));

  /* check various length of msg */  
  printf ("Test various length of preposted msgs.\n");
  fflush(stdout);
  for (i = 0, len = 1; len <= MAX_LEN - 8192; len *= 2, i ++) {
    printf ("  %d\n", len);
    fflush(stdout);
    recv_seg.segment_length = len;
    ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
    send_seg.segment_length = len;
    fill_data(send_buff, len);
    mx_issend(ep, &send_seg, 1, addr, 10, NULL, &send_req[i]);
    mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
    insist((ret == MX_SUCCESS) && (result == 1));
    check_data(recv_buff, len);
  }
  for (i = 0, len = 1; len <= MAX_LEN - 8192; len *= 2, i ++) {
    ret = mx_wait(ep, &send_req[i], MX_INFINITE, &status, &result);
    insist((ret == MX_SUCCESS) && (result == 1));
  }

  /* test 0-length message */
  printf ("Test 0-length msgs.\n");
  send_seg.segment_length = 0;
  recv_buff[0] = 'z';
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  ret = mx_issend(ep, &send_seg, 1, addr, 10, NULL, &send_req[0]);
  ret = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) 
	 && (status.code == MX_STATUS_SUCCESS)
	 && (status.msg_length == 0)
	 && (result == 1));
  insist(recv_buff[0] == 'z');

  printf ("Test 0-length msgs. Null-pointer\n");
  ret = mx_irecv(ep, &null_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  ret = mx_issend(ep, &null_seg, 1, addr, 10, NULL, &send_req[0]);
  ret = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) 
	 && (status.code == MX_STATUS_SUCCESS)
	 && (status.msg_length == 0)
	 && (result == 1));

  printf ("Test truncated short msgs.\n");
  recv_buff[0] = 'z';
  recv_seg.segment_length = 40;
  send_buff[0]= 'a';
  send_seg.segment_length = 80;
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  ret = mx_issend(ep, &send_seg, 1, addr, 10, NULL, &send_req[0]);
  ret = mx_wait(ep, &send_req[0], MX_INFINITE, &status, &result);
  printf ("issend req returns with status.code = %d, msg_length = %d, xfer_length = %d\n", 
	  status.code, status.msg_length, status.xfer_length);
  insist(ret == MX_SUCCESS);
  insist(status.code == MX_STATUS_TRUNCATED && 
	 status.xfer_length == recv_seg.segment_length);
  insist(result == 1);
  ret = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist(ret == MX_SUCCESS);
  insist(status.code == MX_STATUS_TRUNCATED);
  printf ("irecv req returns with status.code = %d, msg_length = %d, xfer_length = %d\n", 
	  status.code, status.msg_length, status.xfer_length);
  insist(status.msg_length == 80);
  insist(status.xfer_length == 40);
  insist(result == 1);

  printf ("Test truncated long msgs.\n");
  recv_buff[0] = 'z';
  recv_seg.segment_length = MAX_LEN - 8192;
  send_buff[0]= 'a';
  send_seg.segment_length = MAX_LEN;
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  ret = mx_issend(ep, &send_seg, 1, addr, 10, NULL, &send_req[0]);
  ret = mx_wait(ep, &send_req[0], MX_INFINITE, &status, &result);
  printf ("issend req returns with status.code = %d, msg_length = %d, xfer_length = %d\n", 
	  status.code, status.msg_length, status.xfer_length);
  insist(ret == MX_SUCCESS);
  /*  insist(status.code == MX_STATUS_TRUNCATED); */
  insist(result == 1);
  ret = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist(ret == MX_SUCCESS);
  insist(status.code == MX_STATUS_TRUNCATED);
  printf ("irecv req returns with status.code = %d, msg_length = %d, xfer_length = %d\n", 
	  status.code, status.msg_length, status.xfer_length);
  insist(status.msg_length == MAX_LEN);
  insist(status.xfer_length == MAX_LEN - 8192);
  insist(result == 1);

  mx_finalize();
  printf("[PASS]\n");
  fflush(stdout);
  return 0;
}
